/*  R van der Werf 14-11-2019 2025 werkt met juiste libraries waarvan backup gemaarkt is 15-6-2025
 *  SWR meter voor Lionel deze versie werkt alleen de berekeningen voor db ed moeten nog gedaan worden
 *   
                      WCMCU-4051              WEMOS D1 MINI PRO
    0-5 V            ____________                ____________
Kanaal1---------Y2  |            | VCC-------5V |            |
Kanaal2---------Y3  |            | VEE-------GND|            |
Kanaal3---------Y4  |            | GND-------GND|            |
                    |            | S0--------D5 |            |
GND ------------GND |            | S1--------D6 |            | 
                    |            | S2--------D7 |            |
                    |            | E---------D8 |            |
                    |            | Z--10K--|-A1 |            |
                    |____________|         |    |____________|
                                          10K
                                           |    
                                          GND
 op de ingangen Y2,Y3 en Y4 spanning deler beveiligd met zenerdiode 5,1V  van 12V naar 5 Volt
 op de Z uitgang panningsdeler 10k/10k  omdat de A1 van WEMOS D1 MINI PRO maximaal 3,3V mag hebben
*/


#include <ESP8266WiFi.h>
#include <ESPAsyncWebServer.h>
#include <Wire.h>
#ifndef APSSID
#define APSSID "SWR"
#define APPSK  ""
#endif

// Put your SSID & Password
const char *ssid = APSSID; // The name of the Wi-Fi network that will be created
const char *password = APPSK;   // The password required to connect to it, leave blank for an open


float Huidige_Kanaal1_Spanning = 0;
float Huidige_Kanaal2_Spanning = 0;
float Huidige_Kanaal3_Spanning = 20;
float Kanaal1_Data[51] = {0}; // Data Kanaal1
float Kanaal2_Data[51] = {0}; // Data Kanaal2
float Kanaal3_Data[51] = {0}; // Data Kanaal3
String Kanaal1DataString;
String Kanaal2DataString;
String Kanaal3DataString;
int LeesKanaal1;  // Gemeten spanning Kanaal1
int LeesKanaal2;  // Gemeten spanning Kanaal2
int LeesKanaal3;  // Gemeten spanning Kanaal3
float ValueKanaal1;  // Gemeten spanning Kanaal1
float ValueKanaal2;  // Gemeten spanning Kanaal2
float ValueKanaal3;  // Gemeten spanning Kanaal3

AsyncWebServer server(80); // Start webserver

String Send_Kanaal1() { // Creates the string which is read/send
  String a = Kanaal1DataString;
  return String(a);
}
String Send_Kanaal2() { // Creates the string which is read/send
  String b = Kanaal2DataString;
  return String(b);
}
String Send_Kanaal3() { // Creates the string which is read/send
  String c = Kanaal3DataString;
  return String(c);
}



void setup() {
  pinMode(D0, OUTPUT);
  pinMode(D1, OUTPUT);
  pinMode(D2, OUTPUT);
  pinMode(D3, OUTPUT);
  pinMode(D4, OUTPUT);
  pinMode(D5, OUTPUT);
  pinMode(D6, OUTPUT);
  pinMode(D7, OUTPUT);
  pinMode(D8, OUTPUT);
  Wire.begin();
  Serial.begin(115200);
  delay(100);
 
  if (!SPIFFS.begin()) {
    return;
  }
 
  WiFi.mode(WIFI_AP_STA);  //need both to serve the webpage and take commands via tcp
  IPAddress ip(1, 2, 3, 4);
  IPAddress gateway(1, 2, 3, 1);
  IPAddress subnet(255, 255, 255, 0);
  WiFi.softAPConfig(ip, gateway, subnet);
  WiFi.softAP(ssid, password);             // Start the access point
  Serial.println("Connecting to ");
  Serial.println(ssid);
  Serial.println(WiFi.localIP());
  
  server.on("/", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send(SPIFFS, "/index.html");
  });
  server.on("/Kanaal1", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send_P(200, "text/plain", Send_Kanaal1().c_str());
  });

  server.on("/Kanaal2", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send_P(200, "text/plain", Send_Kanaal2().c_str());
  });

  server.on("/Kanaal3", HTTP_GET, [](AsyncWebServerRequest * request) {
    request->send_P(200, "text/plain", Send_Kanaal3().c_str());
  });
  server.begin();
  digitalWrite(D8, LOW); //Enable
}

void loop() {
  LeessHuidigeWaarde();
  MaakVerzendString();
  delay(10);
}
void LeessHuidigeWaarde() {
  digitalWrite(D5, HIGH);//Blauw
  digitalWrite(D6, HIGH);//Groen
  digitalWrite(D7, LOW);//Rood
  delay(30);
  LeesKanaal1 = analogRead(A0);
  ValueKanaal1 = map(LeesKanaal1, 0, 700, 0, 500);
  digitalWrite(D5, LOW);//Blauw
  digitalWrite(D6, HIGH);//Groen
  digitalWrite(D7, LOW);//Rood
  delay(30);
  LeesKanaal2 = analogRead(A0);
  ValueKanaal2 = map(LeesKanaal2, 0, 700, 0, 500);
  digitalWrite(D5, LOW);//Blauw
  digitalWrite(D6, LOW);//Groen
  digitalWrite(D7, HIGH);//Rood
  delay(10);
  LeesKanaal3 = analogRead(A0);
  ValueKanaal3 = map(LeesKanaal3, 0, 700, 0, 500);
  Kanaal1DataString = String("");
  Kanaal1_Data[50] = ValueKanaal1;
  Kanaal2_Data[50] = ValueKanaal2;
  Kanaal3_Data[50] = ValueKanaal3;
  
  Kanaal1_Data[0] = ValueKanaal1;
  Kanaal2_Data[0] = ValueKanaal2;
  Kanaal3_Data[0] = ValueKanaal3;
}

void MaakVerzendString() {
  Kanaal1DataString = String("");
  for (int i = 0; i <= 50; i++) {
    if (Kanaal1_Data[i] >= 10.00 || Kanaal1_Data[i] < 0.00) {
      Kanaal1DataString = Kanaal1DataString + String(Kanaal1_Data[i]) + String(" ");
    }
    else
    {
      Kanaal1DataString = Kanaal1DataString + String(Kanaal1_Data[i]) + String("  ");
    }
  }

  // string 7 posities groot maken vaste format
  Kanaal2DataString = String("");
  for (int i = 0; i <= 50; i++) {
    if (Kanaal2_Data[i] >= 10.00 || Kanaal2_Data[i] < 0.00) {
      Kanaal2DataString = Kanaal2DataString + String(Kanaal2_Data[i]) + String(" ");
    }
    else
    {
      Kanaal2DataString = Kanaal2DataString + String(Kanaal2_Data[i]) + String("  ");
    }
  }
  // string 6 posities groot maken vaste format
  Kanaal3DataString = String("");
  for (int i = 0; i <= 50; i++) {
    if (Kanaal3_Data[i] >= 10.00 || Kanaal3_Data[i] < 0.00) {
      Kanaal3DataString = Kanaal3DataString + String(Kanaal3_Data[i]) + String(" ");
    }
    else
    {
      Kanaal3DataString = Kanaal3DataString + String(Kanaal3_Data[i]) + String("  ");
    }
  }
}
